#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <limits>

using namespace std;

struct Point {
    long long x, y;
    bool operator<(const Point& other) const {
        return (x < other.x || (x == other.x && y < other.y));
    }
};

long long cross(const Point& O, const Point& A, const Point& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

vector<Point> convexHull(vector<Point>& points) {
    int n = points.size();
    if (n <= 1) return points;

    sort(points.begin(), points.end());
    vector<Point> hull;

    for (int i = 0; i < n; ++i) {
        while (hull.size() >= 2 && cross(hull[hull.size()-2], hull[hull.size()-1], points[i]) <= 0) {
            hull.pop_back();
        }
        hull.push_back(points[i]);
    }

    size_t lower_size = hull.size();
    for (int i = n - 2; i >= 0; --i) {
        while (hull.size() > lower_size && cross(hull[hull.size()-2], hull[hull.size()-1], points[i]) <= 0) {
            hull.pop_back();
        }
        hull.push_back(points[i]);
    }

    hull.pop_back();
    return hull;
}

long long polygonArea(const vector<Point>& polygon) {
    long long area = 0;
    int n = polygon.size();
    for (int i = 0; i < n; ++i) {
        int j = (i + 1) % n;
        area += polygon[i].x * polygon[j].y - polygon[i].y * polygon[j].x;
    }
    return fabs(area) / 2;
}

int main() {
    int N;
    cin >> N;

    vector<Point> points(N);
    for (int i = 0; i < N; ++i) {
        cin >> points[i].x >> points[i].y;
    }

    long long min_area = numeric_limits<long long>::max();

    for (int i = 0; i < N; ++i) {
        vector<Point> remaining_points;
        for (int j = 0; j < N; ++j) {
            if (i != j) {
                remaining_points.push_back(points[j]);
            }
        }

        vector<Point> hull = convexHull(remaining_points);
        long long area = polygonArea(hull);
        
        long long int_area = area * 2;
        min_area = min(min_area, int_area);
    }

    long long result = min_area / 2;
    
    cout.precision(0);
    cout << fixed << result << endl;

    return 0;
}